﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Reflection;
using System.Diagnostics;

// Program szyfruje klucz programowy na podstawie numeru aktywacyjnego oraz hasła www użytkownika. Jako wejście używa czystego klucza programowego
// wygenerowanego przez niezabezpieczoną wersję programu BezpiecznyProgram.exe
// Dodatkowo program tworzy klucz aktywacji i zapisuje go w pliku klucz_programowy.dat
namespace StwórzKluczBP
{
   class Program
   {
      static byte[] kluczZaciemniajacy = new byte[]{ 11, 22, 189, 240, 1, 111, 112, 76, 127, 44 };      

      /// <summary>
      /// Szfyrowanie klucza programowego
      /// </summary>
      static void SzyfrujKluczProgramowy(string aPlikZKluczemProgramowym, byte[] numerSeryjnyJakoBajty)
      {
         // odczyt pliku z zawartością metody
         System.IO.FileInfo fi = new System.IO.FileInfo(aPlikZKluczemProgramowym);
         long rozmiar = fi.Length;
         byte[] zabezpieczanyKod = new byte[rozmiar];
         Debug.Assert(rozmiar > 8, "Długość zabezpieczanego kodu musi wynosić conajmniej 8 bajtów");

         FileStream fs = File.OpenRead(aPlikZKluczemProgramowym);
         BinaryReader reader = new BinaryReader(fs);
         zabezpieczanyKod = reader.ReadBytes((int)rozmiar);
         reader.Close();
         fs.Close();

         //szyfrowanie klucza programowego
         byte[] zabezpieczonyKluczProgramowy = new byte[zabezpieczanyKod.Length];
         int indeksNumeruSeryjnego = 0;
         for (int i = 0; i < zabezpieczanyKod.Length; i++)
         {
            zabezpieczonyKluczProgramowy[i] = (byte)(zabezpieczanyKod[i] ^ numerSeryjnyJakoBajty[indeksNumeruSeryjnego++]);
            if (indeksNumeruSeryjnego >= numerSeryjnyJakoBajty.Length)
               indeksNumeruSeryjnego = 0;
         }

         //zapis zmodyfikowanego klucza programowego
         FileStream fsw = File.OpenWrite("klucz_programowy.dat");
         BinaryWriter writer = new BinaryWriter(fsw);
         writer.Write(zabezpieczonyKluczProgramowy);
         writer.Close();
         fsw.Close();

         Console.WriteLine(aPlikZKluczemProgramowym + " został zmodyfikowany.");
      }

      public static byte[] HexNaTablicęBajtów(String aHex)
      {
         int ileZnaków = aHex.Length;
         byte[] tablicaBajtów = new byte[ileZnaków / 2];
         for (int i = 0; i < ileZnaków; i += 2)
         {
            tablicaBajtów[i / 2] = Convert.ToByte(aHex.Substring(i, 2), 16);
         }

         return tablicaBajtów;
      }

      static void Main(string[] args)
      {
         // program pobiera następujące parametry:
         // plik_z_kodem_zab - ścieżka do pliku z zabezpieczanym kodem - źródłowym kluczem programowym
         // numer_aktywacyjny - numer aktywacyjny w postaci szestnastkowego tekstu
         // haslo_www - hasło użytkownika - tekst
         // Klucz programowy zostaje zabezpieczony kluczem aktywacji tworzonym poprzez: numer_aktywacyjny XOR haslo_www XOR klucz zaciemniający
         // Do numeru aktywacji zostaje dodany ciąg kontrolny - suma bajtów numeru aktywacji mod 255
         // Zmodyfikowany klucz zostaje zapisany do pliku klucz_programowy.dat

         if (args.Length < 3)
         {
            Console.WriteLine("Prawidłowe wywołanie: StwórzKluczBP.exe plik_z_kodem_zab numer_aktywacyjny haslo_www.");
            Console.WriteLine("  plik_z_kodem_zab - ścieżka do pliku z zabezpieczanym kodem.");
            Console.WriteLine("  numer_aktywacyjny - klucz zabezpieczający.");
            Console.WriteLine("  haslo_www - hasło użytkownika www.");           
         }
         else if (!File.Exists(args[0]))
            Console.WriteLine("Podany plik nie istnieje.");
         else
         {
            byte[] numerAktywacyjnyJakoBajty = HexNaTablicęBajtów(args[1]);
            byte[] hasloWWW = System.Text.Encoding.ASCII.GetBytes(args[2]);

            // zmiana postaci i zaszyfrowanie klucza aktywacyjnego
            int indeksHaslo = 0;
            int indeksKluczZaciemniajacy = 0;
            for (int i = 0; i < numerAktywacyjnyJakoBajty.Length; i++)
            {
               numerAktywacyjnyJakoBajty[i] = (byte)(numerAktywacyjnyJakoBajty[i] ^ hasloWWW[indeksHaslo++] ^ kluczZaciemniajacy[indeksKluczZaciemniajacy++]);
               if (indeksHaslo >= hasloWWW.Length)
                  indeksHaslo = 0;
               if (indeksKluczZaciemniajacy >= kluczZaciemniajacy.Length)
                  indeksKluczZaciemniajacy = 0;
            }

            SzyfrujKluczProgramowy(args[0], numerAktywacyjnyJakoBajty);
         }
      }
   }

}
